
/************************************************************************
 *FILE:           amcontrol_clienthandler_fc_audiomanager.h
 *SW-COMPONENT:      AmRoutingPlugin
 *DESCRIPTION:    ClientHandler for fc_audiomanager
 *AUTHOR:         RBEI/ECG4 - Vyankatesh VD
 *COPYRIGHT:      RBEI
 *HISTORY:
 *20.08.2013      Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 *29.01.2015      Rev 2.0     Martin Koch, Fa. ESE       use direct CCA communication
 ************************************************************************/

#ifndef INCLUDE_AMCONTROL_CLIENT_FC_AUD_MGR_HANDLER_H_IF
#define INCLUDE_AMCONTROL_CLIENT_FC_AUD_MGR_HANDLER_H_IF


/* Include message framework (AMT, msgfw) */
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
/* Include AudioManager FI interface */
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_SERVICEINFO
#include <midw_fi_if.h>

class CAmControlSenderBase;

#include "CThreadSwitchingClient.h"

using namespace am;

class amcontrol_clienthandler_fc_audiomanager : public CThreadSwitchingClient
{
private:
  am::IAmControlReceive& m_ControlReceive;
  CAmControlSenderBase& m_ControlSenderBase;

  bool bAudioDeviceAvailability;
  tU8 ANC_Availability;
  tU8 ASC_Availability;

  //Method results
  bool bOnVolumeModeResult (const FIMessaging::FIMessage& oMsg);
  bool bOnBeepResult (const FIMessaging::FIMessage& oMsg);
  bool bOnLimitResult (const FIMessaging::FIMessage& oMsg);
  bool bOnAmpDeviceAudRouteResult (const FIMessaging::FIMessage& oMsg);
  bool bOnAudioSourceResult (const FIMessaging::FIMessage& oMsg);
  bool bOnMuteResult (const FIMessaging::FIMessage& oMsg);
  bool bOnSystemMuteResult (const FIMessaging::FIMessage& oMsg);
  bool bOnEntertainmentMuteResult (const FIMessaging::FIMessage& oMsg);
  bool bOnAdasSettingSoundResult (const FIMessaging::FIMessage& oMsg);

  //Properties
  bool bOnVolumeStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnBassStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnTrebleStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnMidRangeStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnLoudnessStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnBalanceStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnFaderStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnDynamicCompressionStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnEquPresetStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnSpeedDepVolumeStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnMicConnectionStatus (const FIMessaging::FIMessage& oMsg);

  bool bOnSoundOptimizationStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnSoundRoomEffectStatus (const FIMessaging::FIMessage& oMsg) const;
  bool bOnAuxInLevelStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnBeepLevelStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnBeepStatus (const FIMessaging::FIMessage& oMsg);

  bool bOnLevelCenterStatus (const FIMessaging::FIMessage& oMsg) const;
  bool bOnLevelSubWooferStatus (const FIMessaging::FIMessage& oMsg) const;
  bool bOnSettingSurroundStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnVolumeModeStatus (const FIMessaging::FIMessage& oMsg);

  bool bOnFaderActiveStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnDiagAudioModeStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnFMEnhancerStatus (const FIMessaging::FIMessage& oMsg);

//  void vOnAmpDeviceAudRoute(amt_tclServiceData* poMessage);
  bool bOnPDCActiveStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnPDCAttenuationLevelStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnVolumeListStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnLevelBTAudioInStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnEngineeringDataStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnVolumeLockStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnAudioDeviceStatus (const FIMessaging::FIMessage& oMsg);

  bool bOnCenterStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnSubWooferStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnRoomEffectStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnRearMuteStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnGeometry_ModeStatus (const FIMessaging::FIMessage& oMsg);

  bool bOnDiagDefSetPhaseStatus(const FIMessaging::FIMessage& oMsg);

  //ESE properties
  bool bOnESEDriveModeStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnESESoundTypeStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnESEVolumeStatus (const FIMessaging::FIMessage& oMsg);

  //RSound properties
  bool bOnRSoundOnOffStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnRSoundSoundTypeStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnRSoundVolumeStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnRSoundActivationStatus (const FIMessaging::FIMessage& oMsg);

  //AudioMode status
  bool bOnArkamysAudioModeStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnArkamysAutoGainControlStatus (const FIMessaging::FIMessage& oMsg);

  //ADAS properties status
  bool bOnADAS_UPASoundTypeStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnADAS_ParkAssistanceVolumeStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnADAS_UPAMuteStatus (const FIMessaging::FIMessage& oMsg);
  bool bOnADAS_LDW_UserVolume (const FIMessaging::FIMessage& oMsg);

  bool bOnAmpAvailabilityStatus (const FIMessaging::FIMessage& oMsg);

  bool bOnANC_ASC_ActiveTest_Status (const FIMessaging::FIMessage& oMsg);
  bool bOnANC_ASCSetting (const FIMessaging::FIMessage& oMsg);

  bool bOnUserProfileChange (const FIMessaging::FIMessage& oMsg);

  //support of new interface for amp avail
  tVoid vUpdateAmpavailProperty(midw_mascffi_tclMsgAmpAvailFunctionStatus oStatus);

  // - - - - - - - - - - - - - - - - - - - -

  bool bHandleStatus (const FIMessaging::FIMessage& oMsg);
  bool bHandleError (const FIMessaging::FIMessage& oMsg);
  bool bHandleMethodResult (const FIMessaging::FIMessage& oMsg);

  //Entertainment Startup Volume status
  bool bOnEntVolumeStatus(const FIMessaging::FIMessage& oMsg );

  bool bOnMinimumEntVolumeStatus(const FIMessaging::FIMessage& oMsg );
 //Bose Amplifier Specific
 bool bOnAudioPilot(const FIMessaging::FIMessage& oMsg);
 bool bOnAudioPilotIntensity(const FIMessaging::FIMessage& oMsg);
 bool bOnCenterPoint(const FIMessaging::FIMessage& oMsg);
 bool bOnSurroundVol(const FIMessaging::FIMessage& oMsg);
 bool bOnDriverSound(const FIMessaging::FIMessage& oMsg);
 bool bOnRearSound(const FIMessaging::FIMessage& oMsg);

 //Scene Recorder Sound Notification
 bool bOnSRSoundNotificationStatus(const FIMessaging::FIMessage& oMsg);

 bool bOnRemoveWelcomeSoundMute(const FIMessaging::FIMessage& oMsg);
public:

  // - - - - - - - - - - - - - - - - - - - -
  //
  //      ITarget implementation

  // disclose list of properties which should be UpReg'ed automatically
  virtual FIMessaging::ITarget::AutoRegisterList GetAutoRegisterList (void);

  void vRegisterForProperties();

  // - - - - - - - - - - - - - - - - - - - -

  // callback functions for new messages invoked from Genivi Audiomanager thread
  virtual void vDispatchMessage (FIMessaging::FIMessage oMsg);
  virtual void vOnServiceAvailable (void);
  virtual void vOnServiceUnavailable (void);

  //Default Constructor
  amcontrol_clienthandler_fc_audiomanager(CAmControlSenderBase&,am::IAmControlReceiverShadow&, am::IAmControlReceive& controlReceive);
  amcontrol_clienthandler_fc_audiomanager(tVoid);
  ~amcontrol_clienthandler_fc_audiomanager(tVoid);

  /****************************************************************************
                  Methods of this application
   ****************************************************************************/

  //methods
  tVoid vSetMute(uint8_t,uint8_t,uint8_t,uint8_t,uint8_t);
  tVoid vSetSystemMute(uint8_t,uint8_t,uint8_t,uint8_t);
  virtual tVoid vSetEntertainmentMute(uint8_t,uint8_t,uint8_t,uint8_t);
  tVoid vSetSystemSoundProperty_VolumeMode(uint8_t,uint8_t);
  tVoid vSetSystemSoundProperty_Beep(uint8_t,uint8_t);
  tVoid vSetSystemSoundProperty_ESEDriveMode(uint8_t);
  tVoid vPerformOnVolLimit();
  tVoid vAdasSettingSound_MethodStart(uint8_t);

  //properties
  tVoid vSetVolume(uint8_t,uint8_t,uint8_t);
  virtual tVoid vSetAudioSource(uint8_t,uint8_t,uint8_t);
  tVoid vSetAmpDeviceAudioRoute(uint8_t,uint8_t,uint8_t);

  //Sink Sound properties
  tVoid vSetSinkSoundProperty_Bass(uint8_t,uint8_t,int8_t);
  tVoid vSetSinkSoundProperty_Treble(uint8_t,uint8_t,int8_t);
  tVoid vSetSinkSoundProperty_MidRange(uint8_t,uint8_t,int8_t);
  tVoid vSetSinkSoundProperty_Loudness(uint8_t,uint8_t,int8_t);
  tVoid vSetSinkSoundProperty_Balance(uint8_t,uint8_t,int8_t);
  tVoid vSetSinkSoundProperty_Fader(uint8_t,uint8_t,int8_t);
  tVoid vSetSinkSoundProperty_DynCompression(uint8_t,uint8_t);
  tVoid vSetSinkSoundProperty_PresetEquilizer(uint8_t,uint8_t);
  tVoid vSetSinkSoundProperty_SpeedDepVolChange(uint8_t,uint8_t);
  tVoid vSetSinkSoundProperty_SoundOptimization(uint8_t,uint8_t);
  tVoid vSetSinkSoundProperty_SurroundSetting(uint8_t);
  tVoid vSetSinkSoundProperty_PDCActive(uint8_t,uint8_t);
  tVoid vSetSinkSoundProperty_PDCAttenuationLevel(uint8_t,uint8_t);
  tVoid vSetSinkSoundProperty_VolumeEntertainment(uint8_t);
  tVoid vSetSinkSoundProperty_VolumePhone(uint8_t);
  tVoid vSetSinkSoundProperty_VolumeONVolume(uint8_t);
  tVoid vSetSinkSoundProperty_VolumeTASetup(uint8_t);
  tVoid vSetSinkSoundProperty_VolumeBeep(uint8_t);
  tVoid vSetSinkSoundProperty_BTAudioInLevel(uint8_t,uint8_t);
  tVoid vSetSinkSoundProperty_VolumeLock(uint8_t);
  tVoid vSetSinkSoundProperty_AuxInLevel(uint8_t);
  tVoid vSetSinkSoundProperty_BeepLevel(uint8_t);
  tVoid vSetSinkSoundProperty_RearMute(uint8_t);
  tVoid vSetSinkSoundProperty_VolumeNavigation(uint8_t);
  tVoid vSetSinkSoundProperty_VolumeSDS(uint8_t);
  tVoid vSetSinkSoundProperty_VolumeRingtone(uint8_t);
  tVoid vSetSinkSoundProperty_AudioMode(uint8_t);
  tVoid vSetSinkSoundProperty_Center(uint8_t,uint8_t,uint16_t);
  tVoid vSetSinkSoundProperty_SubWoofer(uint8_t,uint8_t,uint16_t);
  tVoid vSetSinkSoundProperty_RoomEffect(uint8_t,uint8_t);
  tVoid vSetSinkSoundProperty_FMEnhancerMode(uint8_t);
  tVoid vSetSinkSoundProperty_GeometryMode(uint8_t);
  //ESE properties
  tVoid vSetSinkSoundProperty_ESESoundType(uint8_t);
  tVoid vSetSinkSoundProperty_ESEVolume(uint8_t);

  //RSoundType properties
  tVoid vSetSinkSoundProperty_RSoundActivate(uint8_t);
  tVoid vSetSinkSoundProperty_RSoundOnOff(uint8_t);
  tVoid vSetSinkSoundProperty_RSoundSoundType(uint8_t);
  tVoid vSetSinkSoundProperty_RSoundVolume(uint8_t);

  //ADAS properties
  tVoid vSetSystemSoundProperty_ADAS_UPASoundType(uint8_t);
  tVoid vSetSinkSoundProperty_ADAS_ParkAssistanceVolume(uint8_t);
  tVoid vSetSinkSoundProperty_ADAS_UPAMute(uint8_t);
  tVoid vSetSinkSoundProperty_ADAS_LDW_UserVolume(uint8_t);

  //Bose Amplifier Specific
  tVoid vSetSinkSoundProperty_AudioPilotMode(uint8_t);
  tVoid vSetSinkSoundProperty_CenterPointMode(uint8_t);
  tVoid vSetSinkSoundProperty_SurroundVol(uint8_t,uint8_t,uint8_t);
  tVoid vSetSinkSoundProperty_DriverSoundMode(uint8_t);
  tVoid vSetSinkSoundProperty_RearSoundMode(uint8_t);
  tVoid vSetSinkSoundProperty_ANC_ASC_ActiveTest(uint8_t);
  tVoid vSetSinkSoundProperty_ANC_Setting(uint8_t);
  tVoid vSetSinkSoundProperty_ESE_Setting(uint8_t);
  tVoid vSetSinkSoundProperty_ASC_Setting(uint8_t);
  tVoid vSetSinkSoundProperty_AudioPilotIntensity_Setting(uint8_t);

  //Arkamys related properties
  tVoid vSetSinkSoundProperty_ArkamysAutoGainControlSet(uint8_t);
  //Entertainment Configurable  startup  volume related  properties
  tVoid vSetSinkSoundProperty_EntStartupVolume(uint8_t,uint8_t);
  tVoid vSetSinkSoundProperty_EntMinimumStartupVolume(uint8_t,uint8_t);

  //Scene Recorder Sound Notification
  tVoid vSetSinkSoundProperty_SRSoundNotificationState(uint8_t);

  //Get AudioDeviceAvailability
  bool bGetbAudioDeviceAvailability();
};

#endif //INCLUDE_AMCONTROL_CLIENT_FC_AUD_MGR_HANDLER_H_IF
